﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService.Mappers
{
    public class MapTinToCrm : MapperRelatedBase
    {
        public MapTinToCrm(IPpmsContextHelper ppmsContextHelper, IPpmsHelper ppmsHelper)
            : base(ppmsContextHelper, ppmsHelper)
        {
        }

        public async Task<ppms_provideridentifier> MapInsert(Tin schemaTin, Account provider)
        {
            var id = new ppms_provideridentifier
            {
                Id = Guid.NewGuid(),
                ppms_IdentifierType = new OptionSetValue((int)ppms_provideridentifier_ppms_IdentifierType.TaxIDNumber),
                ppms_ProviderIdentifier = schemaTin.Number
            };

            // Set owner to CCN
            if (!ForVaNetwork && Owner != null) id.OwnerId = Owner;

            await Task.Run(() => {});

            return id;
        }

        public async Task<ppms_provideridentifier> MapUpdate(Tin tin, Account provider)
        {
            // check if entity exists
            var crmEntity = GetCrmEntity(provider, tin.Number);
            if (crmEntity == null) return await MapInsert(tin, provider);

            //var entity = new ppms_provideridentifier
            //{
            //    Id = crmEntity.Id,
            //    ppms_IdentifierType = new OptionSetValue((int)ppms_provideridentifier_ppms_IdentifierType.TaxIDNumber),
            //    ppms_ProviderIdentifier = crmEntity.ppms_ProviderIdentifier
            //};

            //// name
            //if (IsChanged(tin.Number, crmEntity.ppms_ProviderIdentifier)) entity.ppms_ProviderIdentifier = tin.Number;

            //// Set owner to CCN
            //if (!ForVaNetwork && Owner != null) entity.OwnerId = Owner;

            // Updates not allowed on TINs
            return null;
        }

        private static ppms_provideridentifier GetCrmEntity(Account provider, string id)
        {
            var list = provider.ppms_account_ppms_provideridentifier_Provider;
            if (list == null) return null;

            var ppmsProvideridentifiers = list as ppms_provideridentifier[] ?? list.ToArray();

            return ppmsProvideridentifiers.Any() ? ppmsProvideridentifiers.FirstOrDefault(x => x.ppms_ProviderIdentifier == id) : null;
        }

        private static Tin ConvertEntity<T>(T entity)
        {
            return (Tin)Convert.ChangeType(entity, typeof(Tin));
        }

        public override async Task<Entity> MapInsert<T>(T entity, Entity parent)
        {
            return await MapInsert(ConvertEntity(entity), (Account)parent);
        }

        public override async Task<Entity> MapUpdate<T>(T entity, Entity parent)
        {
            return await MapUpdate(ConvertEntity(entity), (Account)parent);
        }

        public override void AddChildrenToProvider(IList<Entity> entities, Entity parent)
        {
            if (IsWithinContext) AssociateRelatedEntities(parent, entities, "ppms_account_ppms_provideridentifier_Provider");
            else
            {
                if (entities != null && entities.Count > 0)
                {
                    var account = (Account)parent;
                    if (account != null) account.ppms_account_ppms_provideridentifier_Provider = ConvertEntityList<ppms_provideridentifier>(entities);
                }
            }
        }

        public override IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent)
        {
            if (entities == null || !entities.Any()) return null;

            // Check provider
            var provider = (Account)parent;
            if (provider == null) return null;

            var list = new List<ppms_provideridentifier>();

            // Map schema entities for delete
            foreach (var item in entities)
            {
                var entity = ConvertEntity(item);
                var matches = provider.ppms_account_ppms_provideridentifier_Provider.Where(p => p.ppms_ProviderIdentifier == entity.Number);
                list.AddRange(matches);
            }

            return EntityDelete((IEnumerable<ppms_provideridentifier>)list);
        }
    }
}
